-- phpMyAdmin SQL Dump
-- version 3.4.10.1deb1
-- http://www.phpmyadmin.net
--
-- Servidor: localhost
-- Tiempo de generación: 21-03-2013 a las 09:29:28
-- Versión del servidor: 5.5.29
-- Versión de PHP: 5.3.10-1ubuntu3.6

SET SQL_MODE="NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Base de datos: `ccb`
--

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `clientes`
--

CREATE TABLE IF NOT EXISTS `clientes` (
  `ID` int(10) NOT NULL AUTO_INCREMENT,
  `Nombre` varchar(100) CHARACTER SET utf8 COLLATE utf8_spanish_ci NOT NULL,
  `Alias` varchar(15) CHARACTER SET utf8 COLLATE utf8_spanish_ci NOT NULL,
  `Direccion` varchar(100) CHARACTER SET utf8 COLLATE utf8_spanish_ci DEFAULT NULL,
  `Colonia` varchar(100) CHARACTER SET utf8 COLLATE utf8_spanish_ci DEFAULT NULL,
  `Municipio` varchar(100) CHARACTER SET utf8 COLLATE utf8_spanish_ci DEFAULT NULL,
  `Estado` varchar(100) CHARACTER SET utf32 COLLATE utf32_spanish_ci DEFAULT NULL,
  `CP` varchar(6) CHARACTER SET utf8 COLLATE utf8_spanish_ci DEFAULT NULL,
  `Tel1` varchar(100) CHARACTER SET utf8 COLLATE utf8_spanish_ci DEFAULT NULL,
  `Tel2` varchar(100) CHARACTER SET utf8 COLLATE utf8_spanish_ci DEFAULT NULL,
  `Tel3` varchar(100) CHARACTER SET utf8 COLLATE utf8_spanish_ci DEFAULT NULL,
  `Fax` varchar(100) CHARACTER SET utf8 COLLATE utf8_spanish_ci DEFAULT NULL,
  `E-mail` varchar(100) CHARACTER SET utf8 COLLATE utf8_spanish_ci DEFAULT NULL,
  `Contacto1` varchar(100) CHARACTER SET utf8 COLLATE utf8_spanish_ci DEFAULT NULL,
  `Contacto2` varchar(100) CHARACTER SET utf8 COLLATE utf8_spanish_ci DEFAULT NULL,
  `RFC` varchar(100) CHARACTER SET utf8 COLLATE utf8_spanish_ci DEFAULT NULL,
  PRIMARY KEY (`ID`),
  UNIQUE KEY `Índice1` (`Nombre`),
  UNIQUE KEY `Índice2` (`Alias`),
  UNIQUE KEY `Índice3` (`RFC`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=32 ;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `cuentas_bancarias`
--

CREATE TABLE IF NOT EXISTS `cuentas_bancarias` (
  `Id` int(11) NOT NULL AUTO_INCREMENT,
  `Numero` int(11) NOT NULL,
  `Clabe` varchar(18) CHARACTER SET latin1 DEFAULT NULL,
  `Banco` varchar(25) CHARACTER SET latin1 NOT NULL,
  `Sucursal` varchar(30) CHARACTER SET latin1 DEFAULT NULL,
  `Direccion` varchar(45) CHARACTER SET latin1 DEFAULT NULL,
  `Telefono` varchar(35) CHARACTER SET latin1 DEFAULT NULL,
  `Ejecutivo` varchar(40) CHARACTER SET latin1 DEFAULT NULL,
  `Comentarios` varchar(80) CHARACTER SET latin1 DEFAULT NULL,
  PRIMARY KEY (`Id`),
  UNIQUE KEY `Numero` (`Numero`),
  UNIQUE KEY `Clabe` (`Clabe`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci AUTO_INCREMENT=5 ;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `desglose_gastos`
--

CREATE TABLE IF NOT EXISTS `desglose_gastos` (
  `Id` int(11) NOT NULL AUTO_INCREMENT,
  `Tipo` int(11) NOT NULL,
  `descripcion_dg` varchar(50) DEFAULT NULL,
  `Importe` decimal(10,2) NOT NULL,
  `Iva` decimal(10,2) NOT NULL,
  `Deducible` tinyint(1) NOT NULL DEFAULT '1',
  `Comentario` varchar(256) DEFAULT NULL,
  `fecha` date NOT NULL,
  `id_movban` int(11) NOT NULL,
  `beneficiario` int(11) NOT NULL,
  PRIMARY KEY (`Id`),
  KEY `tipo_constraint` (`Tipo`),
  KEY `id_movban_constraint` (`id_movban`)
) ENGINE=InnoDB  DEFAULT CHARSET=latin1 AUTO_INCREMENT=2198 ;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `desglose_ingresos`
--

CREATE TABLE IF NOT EXISTS `desglose_ingresos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tipo` int(11) NOT NULL,
  `descripcion_ing` varchar(50) NOT NULL,
  `importe` decimal(10,2) NOT NULL,
  `iva` decimal(10,2) NOT NULL,
  `deducible` tinyint(1) NOT NULL,
  `comentario` varchar(256) NOT NULL,
  `fecha` date NOT NULL,
  `id_movban` int(11) NOT NULL,
  `cliente` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=98 ;

-- --------------------------------------------------------

--
-- Estructura Stand-in para la vista `diot`
--
CREATE TABLE IF NOT EXISTS `diot` (
`Importe` decimal(32,2)
,`IVA` decimal(32,2)
,`Total` decimal(33,2)
,`Proveedor` varchar(120)
,`RFC` varchar(13)
);
-- --------------------------------------------------------

--
-- Estructura Stand-in para la vista `diotDesglose`
--
CREATE TABLE IF NOT EXISTS `diotDesglose` (
`Fecha` date
,`Importe` decimal(10,2)
,`IVA` decimal(10,2)
,`Total` decimal(11,2)
,`Proveedor` varchar(120)
,`RFC` varchar(13)
);
-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `facturas`
--

CREATE TABLE IF NOT EXISTS `facturas` (
  `ID` int(10) NOT NULL,
  `Numfactura` int(10) DEFAULT NULL,
  `IdCliente` varchar(100) DEFAULT NULL,
  `Fecha` date DEFAULT NULL,
  `Subtotal` int(10) DEFAULT NULL,
  `IVA` int(10) DEFAULT NULL,
  `Total` int(10) DEFAULT NULL,
  `Totalconletra` varchar(100) DEFAULT NULL,
  `Cancelada` bit(1) DEFAULT NULL,
  PRIMARY KEY (`ID`),
  UNIQUE KEY `Índice1` (`ID`),
  UNIQUE KEY `Índice2` (`Numfactura`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `facturasdetalle`
--

CREATE TABLE IF NOT EXISTS `facturasdetalle` (
  `ID` int(10) NOT NULL,
  `IdFactura` int(10) DEFAULT NULL,
  `Codprod` varchar(10) DEFAULT NULL,
  `Cantidad` int(10) DEFAULT NULL,
  `Precio` int(10) DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `movs_bancarios`
--

CREATE TABLE IF NOT EXISTS `movs_bancarios` (
  `Id` int(11) NOT NULL AUTO_INCREMENT,
  `ingreso` decimal(10,2) DEFAULT NULL,
  `egreso` decimal(10,2) DEFAULT NULL,
  `beneficiario` int(11) DEFAULT NULL,
  `comentario` varchar(100) DEFAULT NULL,
  `cheque` int(11) DEFAULT NULL,
  `referencia` varchar(20) DEFAULT NULL,
  `fecha` date NOT NULL,
  `fecha_operado` date DEFAULT NULL,
  `cta_bancaria` int(11) NOT NULL,
  `tipo_ingreso` tinyint(4) DEFAULT NULL,
  `tipo_egreso` tinyint(4) DEFAULT NULL,
  `conletra` varchar(70) DEFAULT NULL,
  `beneficiari2` varchar(50) DEFAULT NULL,
  `cancelado` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`Id`),
  UNIQUE KEY `movid` (`referencia`,`cheque`),
  KEY `cta_bancaria_constraint` (`cta_bancaria`),
  KEY `beneficiario_constraint` (`beneficiario`)
) ENGINE=InnoDB  DEFAULT CHARSET=latin1 AUTO_INCREMENT=1562 ;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `productos`
--

CREATE TABLE IF NOT EXISTS `productos` (
  `ID` int(10) NOT NULL AUTO_INCREMENT,
  `Codigo` varchar(10) NOT NULL,
  `Descripcion` varchar(100) DEFAULT NULL,
  `Precio` int(10) DEFAULT NULL,
  PRIMARY KEY (`ID`),
  UNIQUE KEY `Índice1` (`Codigo`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=2 ;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `proveedores`
--

CREATE TABLE IF NOT EXISTS `proveedores` (
  `Id` int(11) NOT NULL AUTO_INCREMENT,
  `Nombre` varchar(120) NOT NULL,
  `Direccion` varchar(40) NOT NULL,
  `Colonia` varchar(30) NOT NULL,
  `Ciudad` varchar(20) NOT NULL,
  `CP` int(11) NOT NULL,
  `Telefono` varchar(40) DEFAULT NULL,
  `RFC` varchar(13) NOT NULL,
  `Contacto` varchar(40) DEFAULT NULL,
  `email` varchar(30) DEFAULT NULL,
  `Estado` varchar(25) DEFAULT NULL,
  `Tipo_prov` int(11) DEFAULT NULL,
  PRIMARY KEY (`Id`),
  UNIQUE KEY `rfc_unique` (`RFC`),
  UNIQUE KEY `nombre_unique` (`Nombre`) USING BTREE,
  KEY `tipo_prov_constraint` (`Tipo_prov`)
) ENGINE=InnoDB  DEFAULT CHARSET=latin1 ROW_FORMAT=DYNAMIC AUTO_INCREMENT=150 ;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `rubros_ingresos`
--

CREATE TABLE IF NOT EXISTS `rubros_ingresos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rubro` varchar(30) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `id` (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=latin1 AUTO_INCREMENT=5 ;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `tipos_movs`
--

CREATE TABLE IF NOT EXISTS `tipos_movs` (
  `Id` int(11) NOT NULL AUTO_INCREMENT,
  `Clave` int(11) NOT NULL,
  `Descripcion` varchar(25) NOT NULL,
  PRIMARY KEY (`Id`),
  KEY `clave_index` (`Clave`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `tipos_provs`
--

CREATE TABLE IF NOT EXISTS `tipos_provs` (
  `Id` int(11) NOT NULL AUTO_INCREMENT,
  `Rubro` varchar(25) NOT NULL,
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB  DEFAULT CHARSET=latin1 AUTO_INCREMENT=32 ;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `tipo_egreso`
--

CREATE TABLE IF NOT EXISTS `tipo_egreso` (
  `Id` tinyint(4) NOT NULL AUTO_INCREMENT,
  `Descripcion` varchar(40) CHARACTER SET utf8 COLLATE utf8_spanish_ci NOT NULL,
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB  DEFAULT CHARSET=latin1 AUTO_INCREMENT=10 ;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `tipo_ingreso`
--

CREATE TABLE IF NOT EXISTS `tipo_ingreso` (
  `Id` tinyint(4) NOT NULL AUTO_INCREMENT,
  `Descripcion` varchar(40) NOT NULL,
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB  DEFAULT CHARSET=latin1 AUTO_INCREMENT=5 ;

-- --------------------------------------------------------

--
-- Estructura de tabla para la tabla `usuarios`
--

CREATE TABLE IF NOT EXISTS `usuarios` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `usuario` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `clave` varchar(10) COLLATE utf8_spanish_ci NOT NULL,
  `nombre` varchar(60) COLLATE utf8_spanish_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `key_usuario` (`usuario`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_spanish_ci AUTO_INCREMENT=3 ;

--
-- Volcado de datos para la tabla `usuarios`
--

INSERT INTO `usuarios` (`id`, `usuario`, `clave`, `nombre`) VALUES
(2, 'admin', '12345', '');

-- --------------------------------------------------------

--
-- Estructura para la vista `diot`
--
DROP TABLE IF EXISTS `diot`;

CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`localhost` SQL SECURITY DEFINER VIEW `diot` AS select sum(`desglose_gastos`.`Importe`) AS `Importe`,sum(`desglose_gastos`.`Iva`) AS `IVA`,sum((`desglose_gastos`.`Importe` + `desglose_gastos`.`Iva`)) AS `Total`,`proveedores`.`Nombre` AS `Proveedor`,`proveedores`.`RFC` AS `RFC` from ((`movs_bancarios` join `desglose_gastos`) join `proveedores`) where ((`desglose_gastos`.`Deducible` = 1) and (`movs_bancarios`.`Id` = `desglose_gastos`.`id_movban`) and (`desglose_gastos`.`beneficiario` = `proveedores`.`Id`) and (`movs_bancarios`.`fecha` between '09/09/01' and '09/09/30')) group by `proveedores`.`Nombre` with rollup;

-- --------------------------------------------------------

--
-- Estructura para la vista `diotDesglose`
--
DROP TABLE IF EXISTS `diotDesglose`;

CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`localhost` SQL SECURITY DEFINER VIEW `diotDesglose` AS select `desglose_gastos`.`fecha` AS `Fecha`,`desglose_gastos`.`Importe` AS `Importe`,`desglose_gastos`.`Iva` AS `IVA`,(`desglose_gastos`.`Importe` + `desglose_gastos`.`Iva`) AS `Total`,`proveedores`.`Nombre` AS `Proveedor`,`proveedores`.`RFC` AS `RFC` from ((`movs_bancarios` join `desglose_gastos`) join `proveedores`) where ((`desglose_gastos`.`id_movban` = `movs_bancarios`.`Id`) and (`desglose_gastos`.`beneficiario` = `proveedores`.`Id`) and (`movs_bancarios`.`fecha` between '09/09/01' and '09/09/30')) order by `proveedores`.`Nombre`;

--
-- Restricciones para tablas volcadas
--

--
-- Filtros para la tabla `desglose_gastos`
--
ALTER TABLE `desglose_gastos`
  ADD CONSTRAINT `id_movban_constraint` FOREIGN KEY (`id_movban`) REFERENCES `movs_bancarios` (`Id`),
  ADD CONSTRAINT `tipo_constraint` FOREIGN KEY (`Tipo`) REFERENCES `tipos_provs` (`Id`);

--
-- Filtros para la tabla `movs_bancarios`
--
ALTER TABLE `movs_bancarios`
  ADD CONSTRAINT `beneficiario_constraint` FOREIGN KEY (`beneficiario`) REFERENCES `proveedores` (`Id`),
  ADD CONSTRAINT `cta_bancaria_constraint` FOREIGN KEY (`cta_bancaria`) REFERENCES `cuentas_bancarias` (`Numero`);

--
-- Filtros para la tabla `proveedores`
--
ALTER TABLE `proveedores`
  ADD CONSTRAINT `tipo_prov_constraint` FOREIGN KEY (`Tipo_prov`) REFERENCES `tipos_provs` (`Id`);

/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
